Attribute VB_Name = "Config"
Option Explicit

'----------------------------------------------------------
'  Myriad
'  Configuration Module
'----------------------------------------------------------
'  Version 1.0.1 (2004-05-26)
'  1.0.0: Module created.  It's basically some of Myriad's
'         Config module.
'  1.0.1: Added settings for web channel. (Cloaked)
'----------------------------------------------------------

Private Declare Function WritePrivateProfileString Lib "kernel32" Alias "WritePrivateProfileStringA" (ByVal lpApplicationName As String, ByVal lpKeyName As String, ByVal lpString As Any, ByVal lpFileName As String) As Long
Private Declare Function WritePrivateProfileSection Lib "kernel32" Alias "WritePrivateProfileSectionA" (ByVal lpAppName As String, ByVal lpString As String, ByVal lpFileName As String) As Long
Private Declare Function GetPrivateProfileSection Lib "kernel32" Alias "GetPrivateProfileSectionA" (ByVal lpAppName As String, ByVal lpReturnedString As String, ByVal nSize As Long, ByVal lpFileName As String) As Long
Private Declare Function GetPrivateProfileString Lib "kernel32" Alias "GetPrivateProfileStringA" _
    (ByVal lpApplicationName As String, ByVal lpKeyName As String, ByVal lpDefault As String, _
    ByVal lpReturnedString As String, ByVal nSize As Long, ByVal lpFileName As String) As Long

Public Function ConfigString(Key$, ByRef Destination$, Optional Category$ = "Main") As Boolean
    Dim strTMP$
    strTMP = GetConfig(Key, Category)
    If LenB(strTMP) Then
        Destination = strTMP
        ConfigString = True
    Else
        ConfigString = False
    End If
End Function

Public Sub ConfigBool(Key$, Destination As Boolean, Optional Category$ = "Main")
    Destination = GetBoolean(Key, Category)
End Sub
    

Function GetConfig(Key$, Optional Category$ = "Main", Optional ByVal Default As String = "") As String
On Error Resume Next
    GetConfig = GetFromINI("config.ini", Category, Key, Default)
End Function

Function GetBoolean(Key$, Optional Category$ = "Main", Optional Default As Boolean = False) As Boolean
On Error Resume Next
    Dim strTMP$
    strTMP = LCase$(GetFromINI("config.ini", Category, Key))
    Select Case strTMP
        Case "yes", "y", "true", "on", "1", "active", "enabled"
            GetBoolean = True
        Case "no", "n", "false", "off", "0", "inactive", "disabled"
            GetBoolean = False
        Case Else
            GetBoolean = Default
    End Select
End Function

Function WriteConfig(Key$, ByVal strValue$, Optional Category$ = "Main") As Boolean
On Error Resume Next
    WriteConfig = WriteToINI("config.ini", Category, Key, strValue)
End Function

Function WriteBoolean(Key$, Value As Boolean, Optional Category$ = "Main") As Boolean
On Error Resume Next
    If Value Then
        WriteBoolean = WriteToINI("config.ini", Category, Key, "Yes")
    Else
        WriteBoolean = WriteToINI("config.ini", Category, Key, "No")
    End If
End Function

Private Function GetFromINI(INIFile$, Category$, Key$, Optional ByVal sDefault As String = "") As String
On Error Resume Next
    Dim sFile$, lSize%, L As Long, sUser$
    sUser = Space$(255)
    lSize = 255
    sFile = App.Path & "\" & INIFile
    L = GetPrivateProfileString(Category, Key, sDefault, sUser, lSize, sFile)
    sUser = RTrim$(sUser)
    GetFromINI = Left$(sUser, Len(sUser) - 1)
End Function

Private Function WriteToINI(INIFile$, Category$, Key$, ByVal strValue$) As Boolean
On Error Resume Next
    Dim sFile$, L As Long
    WriteToINI = False
On Error GoTo WT_Error
    sFile = App.Path & "\" & INIFile
    L = WritePrivateProfileString(Category, Key, strValue, sFile)
    WriteToINI = True
    
WT_Error:
    If Err.Number <> 0 Then MsgBox "Error while saving configuration: " & Err.Description, vbExclamation, "CloakedChat " & verMajor & "." & verMinor
End Function

Public Sub LoadPreferences()
    Dim i&
    WebbotSetup
    For i = 0 To 6
        Select Case i
            Case cbStarCraft: clientBanData(i) = GetBoolean("STAR", "ClientBans")
            Case cbBroodWar: clientBanData(i) = GetBoolean("SEXP", "ClientBans")
            Case cbDiablo2: clientBanData(i) = GetBoolean("D2DV", "ClientBans")
            Case cbDiablo2x: clientBanData(i) = GetBoolean("D2XP", "ClientBans")
            Case cbWarCraft2: clientBanData(i) = GetBoolean("W2BN", "ClientBans")
            Case cbWarCraft3: clientBanData(i) = GetBoolean("WAR3", "ClientBans")
            Case cbWarCraft3x: clientBanData(i) = GetBoolean("W3XP", "ClientBans")
        End Select
    Next i
    
End Sub

Public Function BoolToCheck(Value As Boolean) As CheckBoxConstants
    Select Case Value
        Case True: BoolToCheck = vbChecked
        Case False: BoolToCheck = vbUnchecked
    End Select
End Function

Public Function CheckToBool(Value As CheckBoxConstants) As Boolean
    Select Case Value
        Case vbChecked: CheckToBool = True
        Case vbUnchecked: CheckToBool = False
    End Select
End Function

Public Function CheckToSet(Value As CheckBoxConstants) As String
    Select Case Value
        Case vbChecked: CheckToSet = "Yes"
        Case vbUnchecked: CheckToSet = "No"
    End Select
End Function

Public Sub SetEventLog(NewValue As Boolean)
    logEvents = NewValue
    frmMain.mnuSettingsLoggingEvents.Checked = NewValue
    frmMain.mnuSettingsLoggingEventsDisk.Enabled = NewValue
    WriteBoolean "Enabled", NewValue, "EventLog"
    If logEvents Then
        logWindowSize = CLng(Val(GetConfig("WindowHeight", "EventLog")))
        If logWindowSize <= 0 Then _
            logWindowSize = 1575
    Else
        logWindowSize = 0
    End If
    frmMain.onResize
End Sub

Public Sub WebbotSetup()
    'ConfigBool "Enabled", wbEnabled, "WebChannel"
    'ConfigString "URL", wbURL, "WebChannel"
    'If LenB(wbURL) = 0 Then wbURL = "http://webbot.ionws.com/"
    'If wbEnabled Then
    '    Set WB = New WebBot
    '    WB.Initialize KoGBot, wbURL, GetConfig("Username")
    'End If
End Sub
